<?PHP
    class ReportExport extends DAOControl
    {
        function __construct()
        {
            parent::__construct();
            include_once('External/PHPExcel.php');
        }

        function createExcel() {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()
                ->setCreator("e2care system")
                ->setLastModifiedBy("e2care system")
                ->setTitle("ST Report")
                ->setSubject("e2care")
                ->setDescription("st report")
                ->setKeywords("st report")
                ->setCategory("st report");

            $objPHPExcel->setActiveSheetIndex(0);
            return $objPHPExcel;
        }

        function saveExcel($objPHPExcel, $reportName) {
            $excelfilename = "temp/exe_report_".date(Ymd)."_".$reportName.".xls";
            if (file_exists($excelfilename)) {
                unlink($excelfilename);
            }
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save($excelfilename);
            return $excelfilename;
        }

        function getAxDetailReport($data, $name, $serviceuserid, $stName) {
            // echo '<pre>';print_r($data);exit();
            $uncheckedBox = json_decode('"\u25A1"');
            $checkedBox = json_decode('"\u2611"');
            $scaleArr = array("None", "Mild", "Moderate", "Severe");

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("Pt Ax Detailed Report");
            $colarr = Helpers_GetExcelColumn::get();

            $rowi=1;
            $sheet->setCellValue($colarr[0].$rowi++, "Pt Ax Detailed Report");
            $sheet->setCellValue($colarr[0].$rowi, "Speech Therapist");
            $sheet->setCellValue($colarr[1].$rowi++, $stName);
            $sheet->setCellValue($colarr[0].$rowi, "Client");
            $sheet->setCellValue($colarr[1].$rowi++, $name);
            $sheet->setCellValue($colarr[0].$rowi, "Assessment Date");
            $sheet->setCellValue($colarr[1].$rowi, "Test");
            $sheet->setCellValue($colarr[2].$rowi, "Result");
            $sheet->mergeCells($colarr[3].$rowi.":".$colarr[4].$rowi);
            $sheet->setCellValue($colarr[3].$rowi, "Score");
            $sheet->setCellValue($colarr[5].$rowi++, "Speech Therapist");

            foreach ($data as $value) {
                $recordFirstRow = $rowi;
                $sheet->setCellValue($colarr[0].$recordFirstRow, $value["confirm_date"]);
                $sheet->setCellValue($colarr[1].$recordFirstRow, $value["type"]);
                $sheet->setCellValue($colarr[5].$recordFirstRow, $value["confirm_userid"]);

                // result
                foreach ($value["result"] as $key => $resultItem) {
                    $resultString = "";
                    for ($i=0; $i < count($resultItem["options"]); $i++) {
                        $box = "";
                        if (strlen($resultItem["selected"]) > 0 && $i == $resultItem["selected"]) {
                            $box = $checkedBox;
                        }
                        else {
                            $box = $uncheckedBox;
                        }
                        $resultString .= $box.$resultItem["options"][$i];
                    }

                    $sheet->setCellValue($colarr[2].$recordFirstRow++, $key." ".$resultString);
                }

                // score
                $recordFirstRow = $rowi;
                foreach ($value["score"] as $key => $resultItem) {
                    if ($key == "appendScale") {
                        $appendScaleRow = $rowi;
                        for ($i=0; $i < count($resultItem["computed"]); $i++) {
                            $resultString = "";
                            for ($j=0; $j < count($resultItem["scale"][$i]); $j++) {
                                $box = "";
                                if (strlen($resultItem["computed"][$i]) > 0 && $j == $resultItem["computed"][$i]) {
                                    $box = $checkedBox;
                                }
                                else {
                                    $box = $uncheckedBox;
                                }
                                $resultString .= $box.$scaleArr[$j].$resultItem["scale"][$i][$j];
                            }
                            $sheet->setCellValue($colarr[4].$appendScaleRow++, $resultString);
                        }
                        continue;
                    }
                    $resultString = "";
                    if (isset($resultItem["score"])) {
                       // $resultString = $resultItem["score"]."/".$resultItem["max"];
                        $resultString = number_format($resultItem["score"], 2) ." / ".$resultItem["max"];
                    }
                    // Kelvin 20160804: if need not to print empty box, enable the if case
                    // if (isset($resultItem["selected"])) {
                        for ($i=0; $i < count($resultItem["options"]); $i++) {
                            $box = "";
                            if (strlen($resultItem["selected"]) > 0 && $i == $resultItem["selected"]) {
                                $box = $checkedBox;
                            }
                            else {
                                $box = $uncheckedBox;
                            }
                            $resultString .= $box.$resultItem["options"][$i];
                        }
                    // }
                    $sheet->setCellValue($colarr[3].$recordFirstRow++, $key." ".$resultString);
                }

                $rowi = $recordFirstRow;
            }


            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }
            return $this->saveExcel($objPHPExcel, "ax_detail_".$serviceuserid);
        }

        function getAxSimpleReport($data, $name, $serviceuserid, $stName) {
            // print_r($data);exit();
            $uncheckedBox = json_decode('"\u25A1"');
            $checkedBox = json_decode('"\u2611"');
            $scaleArr = array("None", "Mild", "Moderate", "Severe");

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("Pt Ax Simple Report");
            $colarr = Helpers_GetExcelColumn::get();

            $rowi=1;
            $sheet->setCellValue($colarr[0].$rowi++, "Pt Ax Simple Report");
            $sheet->setCellValue($colarr[0].$rowi, "參加者");
            $sheet->setCellValue($colarr[1].$rowi++, $name);
            $sheet->setCellValue($colarr[0].$rowi, "負責言語治療師");
            $sheet->setCellValue($colarr[1].$rowi++, $stName);
            $sheet->setCellValue($colarr[0].$rowi++, "最近記錄");
            $sheet->setCellValue($colarr[0].$rowi, "評估日期");
            $sheet->setCellValue($colarr[1].$rowi, "結果");
            $sheet->setCellValue($colarr[2].$rowi++, "測試");

            foreach ($data as $value) {
                $recordFirstRow = $rowi;
                $sheet->setCellValue($colarr[0].$recordFirstRow, $value["confirm_date"]);
                $sheet->setCellValue($colarr[2].$recordFirstRow, $value["type"]);

                // result
                foreach ($value["result"] as $key => $resultItem) {
                    $resultString = "";
                    for ($i=0; $i < count($resultItem["options"]); $i++) {
                        $box = "";
                        if (strlen($resultItem["selected"]) > 0 && $i == $resultItem["selected"]) {
                            $box = $checkedBox;
                        }
                        else {
                            $box = $uncheckedBox;
                        }
                        $resultString .= $box.$resultItem["options"][$i];
                    }

                    $sheet->setCellValue($colarr[1].$recordFirstRow++, $key." ".$resultString);
                }

                $rowi = $recordFirstRow;
            }


            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }
            return $this->saveExcel($objPHPExcel, "ax_simple_".$serviceuserid);
        }

       // function getExDetailReport($userid, $name, $serviceuserid, $startdate, $enddate) {
		function getExDetailReport($userid, $name, $serviceuserid, $stName, $startdate, $enddate) {
            $data = $this->getExerciseData($userid, $startdate, $enddate);
            // print_r($data);exit();

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("Pt Ex Detailed Report");
            $colarr = Helpers_GetExcelColumn::get();

            $sheet->setCellValue($colarr[0]."1", "Pt Ex Detailed Report");
            $sheet->setCellValue($colarr[0]."2", "參加者");
            $sheet->setCellValue($colarr[1]."2", $name);
            $sheet->setCellValue($colarr[0]."3", "訓練內容");
            $sheet->setCellValue($colarr[1]."3", "練習");
            $sheet->setCellValue($colarr[2]."3", "難度");			
            $sheet->setCellValue($colarr[3]."3", "首次練習時間");
            $sheet->setCellValue($colarr[4]."3", "最近練習時間");
            $sheet->setCellValue($colarr[5]."3", "練習時數");
            $sheet->setCellValue($colarr[6]."3", "平均分數");
            $sheet->setCellValue($colarr[7]."3", "最高得分");
            $sheet->setCellValue($colarr[8]."3", "最高得分是否已達標 (標準80%)");
            $sheet->setCellValue($colarr[9]."3", "提示");
            $sheet->setCellValue($colarr[10]."3", "答案");
            $sheet->setCellValue($colarr[11]."3", "個別練習");
            $sheet->setCellValue($colarr[12]."3", "小組");
            $sheet->setCellValue($colarr[13]."3", "練習次數");
            $sheet->setCellValue($colarr[14]."3", "負責言語治療師");
            $sheet->setCellValue($colarr[15]."3", "言語治療師評語");
            $sheet->setCellValue($colarr[15]."3", "訓練者");
            $sheet->setCellValue($colarr[16]."3", "評語");

            $rowi = 3;
            foreach ($data as $item) {
                $rowi++;
                $sheet->setCellValue($colarr[0].$rowi, $item["exeName"]);
                $sheet->setCellValue($colarr[1].$rowi, $item["exeNum"]);
                $sheet->setCellValue($colarr[2].$rowi, $item["exeLevel"]);
                $sheet->setCellValue($colarr[3].$rowi, $item["minTime"]);
                $sheet->setCellValue($colarr[4].$rowi, $item["maxTime"]);
                $sheet->setCellValue($colarr[5].$rowi, $item["totalHour"]);
                $sheet->setCellValue($colarr[6].$rowi, $item["avgScore"]);
                $sheet->setCellValue($colarr[7].$rowi, $item["maxScore"]);
                // $sheet->setCellValue($colarr[8].$rowi, $item["maxPercentage"]."%（標準".$item["exePassRate"]."%）");
				if ($item["maxPercentage"] >= 80) {
					$sheet->setCellValue($colarr[8].$rowi, "是");
				} else {
					$sheet->setCellValue($colarr[8].$rowi, "否");
				}
                $sheet->setCellValue($colarr[9].$rowi, $item["cueDetail"]);
                $sheet->setCellValue($colarr[10].$rowi, 0);
                $sheet->setCellValue($colarr[11].$rowi, $item["numIndExe"]);
                $sheet->setCellValue($colarr[12].$rowi, $item["numGrpExe"]);
                $sheet->setCellValue($colarr[13].$rowi, $item["numExe"]);
                $sheet->setCellValue($colarr[14].$rowi, $item["stName"]);
                // $sheet->setCellValue($colarr[10].$rowi, $item["stComment"]);
                $sheet->setCellValue($colarr[15].$rowi, $item["commentName"]);
                $sheet->setCellValue($colarr[16].$rowi, $item["comment"]);
            }

            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }

            return $this->saveExcel($objPHPExcel, "ex_detail_".$serviceuserid);
        }

        function getExSimpleReport($userid, $name, $serviceuserid, $stName, $startdate, $enddate) {
            $data = $this->getExerciseData($userid, $startdate, $enddate);
            // print_r($data);exit();

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("Pt Ex Simple Report");
            $colarr = Helpers_GetExcelColumn::get();

            if (empty($startdate) && empty($enddate)) {
                $trainingPeriod = "All";
            }
            else {
                if (empty($startdate)) {
                    $startdate = "Past";
                }
                if (empty($enddate)) {
                    $enddate = "Current";
                }
                $trainingPeriod = $startdate." to ".$enddate;
            }

            $rowi = 1;
            $sheet->setCellValue($colarr[0].$rowi++, "Pt Ex Simple Report");
            $sheet->setCellValue($colarr[0].$rowi, "參加者");
            $sheet->setCellValue($colarr[1].$rowi++, $name);
            $sheet->setCellValue($colarr[0].$rowi, "負責言語治療師");
            $sheet->setCellValue($colarr[1].$rowi++, $stName);
            $sheet->setCellValue($colarr[0].$rowi, "訓練時段");
            $sheet->setCellValue($colarr[1].$rowi++, $trainingPeriod);
            $sheet->setCellValue($colarr[0].$rowi, "報告日期");
            $sheet->setCellValue($colarr[1].$rowi++, date("Y-m-d"));
            $rowi++;

            $sheet->setCellValue($colarr[0].$rowi, "訓練內容");
            $sheet->setCellValue($colarr[1].$rowi, "練習");
            $sheet->setCellValue($colarr[2].$rowi, "難度");
            $sheet->setCellValue($colarr[3].$rowi, "總共練習時數");
            $sheet->setCellValue($colarr[4].$rowi, "平均分數");
            $sheet->setCellValue($colarr[5].$rowi, "最高得分");
            $sheet->setCellValue($colarr[6].$rowi, "個別練習");
            $sheet->setCellValue($colarr[7].$rowi, "小組");
            $sheet->setCellValue($colarr[8].$rowi, "總共練習次數");

            foreach ($data as $item) {
                $rowi++;
                $sheet->setCellValue($colarr[0].$rowi, $item["exeName"]);
                $sheet->setCellValue($colarr[1].$rowi, $item["exeNum"]);
                $sheet->setCellValue($colarr[2].$rowi, $item["exeLevel"]);
                $sheet->setCellValue($colarr[3].$rowi, $item["totalHour"]);
                $sheet->setCellValue($colarr[4].$rowi, $item["avgScore"]);
                $sheet->setCellValue($colarr[5].$rowi, $item["maxScore"]);
                $sheet->setCellValue($colarr[6].$rowi, $item["numIndExe"]);
                $sheet->setCellValue($colarr[7].$rowi, $item["numGrpExe"]);
                $sheet->setCellValue($colarr[8].$rowi, $item["numExe"]);
            }

            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }

            return $this->saveExcel($objPHPExcel, "ex_simple_".$serviceuserid);
        }

        function getExerciseData($userid, $startdate, $enddate) {
            $query = $this->pdo->prepare("SELECT att.puserid, es.exe_name, es.exe_num, es.exe_level, es.exe_id, att.attempt_start_datetime, att.attempt_end_datetime, att.attempt_score, att.attempt_percentage, att.attempt_type, es.exe_pass_rate, att.comment_role, att.comment_name, att.free_comment, (SELECT update_staff_id FROM ams.exe_control c WHERE puserid=? AND att.exe_name = c.exe_id ) staff,att.q1c1,att.q1c2,att.q1c3,att.q1c4,att.q2c1,att.q2c2,att.q2c3,att.q2c4,att.q3c1,att.q3c2,att.q3c3,att.q3c4,att.q4c1,att.q4c2,att.q4c3,att.q4c4,att.q5c1,att.q5c2,att.q5c3,att.q5c4,att.q6c1,att.q6c2,att.q6c3,att.q6c4,att.q7c1,att.q7c2,att.q7c3,att.q7c4,att.q8c1,att.q8c2,att.q8c3,att.q8c4,att.q9c1,att.q9c2,att.q9c3,att.q9c4,att.q10c1,att.q10c2,att.q10c3,att.q10c4,att.q11c1,att.q11c2,att.q11c3,att.q11c4,att.q12c1,att.q12c2,att.q12c3,att.q12c4,att.q13c1,att.q13c2,att.q13c3,att.q13c4,att.q14c1,att.q14c2,att.q14c3,att.q14c4,att.q15c1,att.q15c2,att.q15c3,att.q15c4,att.q16c1,att.q16c2,att.q16c3,att.q16c4,att.q17c1,att.q17c2,att.q17c3,att.q17c4,att.q18c1,att.q18c2,att.q18c3,att.q18c4,att.q19c1,att.q19c2,att.q19c3,att.q19c4,att.q20c1,att.q20c2,att.q20c3,att.q20c4 FROM (SELECT puserid,exe_name,attempt_start_datetime,attempt_end_datetime,attempt_score,attempt_percentage,attempt_type,comment_role,comment_name,free_comment,q1c1,q1c2,q1c3,q1c4,q2c1,q2c2,q2c3,q2c4,q3c1,q3c2,q3c3,q3c4,q4c1,q4c2,q4c3,q4c4,q5c1,q5c2,q5c3,q5c4,q6c1,q6c2,q6c3,q6c4,q7c1,q7c2,q7c3,q7c4,q8c1,q8c2,q8c3,q8c4,q9c1,q9c2,q9c3,q9c4,q10c1,q10c2,q10c3,q10c4,q11c1,q11c2,q11c3,q11c4,q12c1,q12c2,q12c3,q12c4,q13c1,q13c2,q13c3,q13c4,q14c1,q14c2,q14c3,q14c4,q15c1,q15c2,q15c3,q15c4,q16c1,q16c2,q16c3,q16c4,q17c1,q17c2,q17c3,q17c4,q18c1,q18c2,q18c3,q18c4,q19c1,q19c2,q19c3,q19c4,q20c1,q20c2,q20c3,q20c4 FROM ams.attempt_set WHERE attempt_set.puserid=? and attempt_set.attempt_start_datetime >= ? and attempt_set.attempt_start_datetime <= DATE_ADD(?, INTERVAL 1 DAY) ) att, ams.exe_setting es WHERE att.exe_name IN (SELECT exe_id FROM ams.exe_setting) AND att.exe_name = es.exe_id");
			if (empty($startdate)) {
                $startdate = "0000-01-01";
            }
            if (empty($enddate)) {
                $enddate = "9999-12-30";
            }
            $query->execute(array($userid,$userid,$startdate,$enddate));
            $attempts = $query->fetchAll();
            $exeAtt = array();
            foreach ($attempts as $att) {
                if (!isset($exeAtt[$att["exe_id"]])) {
                    $exeAtt[$att["exe_id"]] = array();
                }
                array_push($exeAtt[$att["exe_id"]], $att);
            }

		
			
            $report = array();
            foreach ($exeAtt as $exeid => $attemptArr) {
                $maxTime = "0000-00-00 00:00:00";
                $minTime = "9999-99-99 99:99:99";
                $totalScore = 0;
                $maxScore = -Infinity;
                $maxPercentage = -Infinity;
                $numExe = 0;
                $numIndExe = 0;
                $numGrpExe = 0;
                $exePassRate = -Infinity;
                $exeName = "";
                $exeNum = "";
                $exeLevel = "";
                $normalComment = "";
                $normalName = "";
                $stName = "";
                $stComment = "";
                $t = 0;
                $cueDetail = array();

                foreach ($attemptArr as $att) {
				// if (($att["attempt_start_datetime"] >= $startdate) && ($att["attempt_start_datetime"] <= $enddate)) {
				
                    $numExe++;
					if ($att["attempt_type"] == 1) {
						$numIndExe++;
					} else {
						$numGrpExe++;
					}
                    $totalScore += $att["attempt_percentage"];
                    if ($att["attempt_percentage"] > $maxScore) {
                        $maxScore = $att["attempt_percentage"];
                        $maxPercentage = $att["attempt_percentage"];
                        $exePassRate = $att["exe_pass_rate"];
                    }
                    if ($att["attempt_start_datetime"] < $minTime) {
                        $minTime = $att["attempt_start_datetime"];
                    }
                    if ($att["attempt_end_datetime"] > $maxTime) {
                        $maxTime = $att["attempt_end_datetime"];
                    }
                    $t += strtotime($att["attempt_end_datetime"])-strtotime($att["attempt_start_datetime"]);
                    $exeName = $att["exe_name"];
                    $exeNum = $att["exe_num"];
                    $exeLevel = $att["exe_level"];
                    if (!empty($att["free_comment"])) {
                        // todo: need to know the name of st used in the app
                        $normalComment .= date("Y-m-d", strtotime($att["attempt_start_datetime"])).": ".$att["free_comment"]."\r\n";
                        if ($att["comment_role"] != "治療師") {
                            $normalName .= $att["comment_name"]."\r\n";
                        }
                        else {
                            // $stComment .= date("Y-m-d", strtotime($att["attempt_start_datetime"])).": ".$att["free_comment"]."\r\n";
                            $stName .= $att["comment_name"]."\r\n";
                        }
                    }

                    $cueQuestionArray = array("q1c1","q1c2","q1c3","q1c4","q2c1","q2c2","q2c3","q2c4","q3c1","q3c2","q3c3","q3c4","q4c1","q4c2","q4c3","q4c4","q5c1","q5c2","q5c3","q5c4","q6c1","q6c2","q6c3","q6c4","q7c1","q7c2","q7c3","q7c4","q8c1","q8c2","q8c3","q8c4","q9c1","q9c2","q9c3","q9c4","q10c1","q10c2","q10c3","q10c4","q11c1","q11c2","q11c3","q11c4","q12c1","q12c2","q12c3","q12c4","q13c1","q13c2","q13c3","q13c4","q14c1","q14c2","q14c3","q14c4","q15c1","q15c2","q15c3","q15c4","q16c1","q16c2","q16c3","q16c4","q17c1","q17c2","q17c3","q17c4","q18c1","q18c2","q18c3","q18c4","q19c1","q19c2","q19c3","q19c4","q20c1","q20c2","q20c3","q20c4");
                    for ($idx=0; $idx < sizeof($cueQuestionArray); $idx++) {
                        if (!empty($att[$cueQuestionArray[$idx]])) {
                            $queNum = explode("c", $cueQuestionArray[$idx])[1];
                            $queQuestion = explode("q", explode("c", $cueQuestionArray[$idx])[0])[1];
                            if (!isset($cueDetail[$att["attempt_start_datetime"]])) {
                                $cueDetail[$att["attempt_start_datetime"]] = array();
                            }
                            if (!isset($cueDetail[$att["attempt_start_datetime"]]["Question ".$queQuestion])) {
                                $cueDetail[$att["attempt_start_datetime"]]["Question ".$queQuestion] = array();
                            }
                            array_push($cueDetail[$att["attempt_start_datetime"]]["Question ".$queQuestion], "cue".$queNum);
                        }
                    }
				// }
                }

                $cueDetailString = "";
                foreach ($cueDetail as $attemptTime => $usedQuestionCueArr) {
                    $cueDetailString .= $attemptTime."\r\n";
                    foreach ($usedQuestionCueArr as $questionNum => $usedCueArr) {
                        $cueDetailString .= $questionNum." with ".implode(" ", $usedCueArr)."\r\n";
                    }
                    $cueDetailString .= "\r\n";
                }

                $report[$exeid] = array(
                    "exeName" => $exeName,
                    "exeNum" => $exeNum,
                    "exeLevel" => $exeLevel,
                    "maxTime" => $maxTime,
                    "minTime" => $minTime,
                    "totalHour" => sprintf('%02d:%02d:%02d', ($t/3600),($t/60%60), $t%60),
                    "avgScore" => number_format($totalScore/$numExe, 2),
                    "maxScore" => $maxScore,
                    "maxPercentage" => $maxPercentage,
                    "numExe" => $numExe,
                    "exePassRate" => $exePassRate,
                    "numExe" => $numExe,
                    "numIndExe" => $numIndExe,
                    "numGrpExe" => $numGrpExe,
                    "staff" => $att["staff"],
                    "comment" => $normalComment,
                    "commentName" => $normalName,
                    // "stComment" => $stComment,
                    "stName" => $stName,
                    "cueDetail" => $cueDetailString,
                );
            }
            return $report;
        }

        function getHAReport($data, $name, $serviceuserid, $userid, $stName, $startdate, $enddate) {
            $uncheckedBox = json_decode('"\u25A1"');
            $checkedBox = json_decode('"\u2611"');
            $scaleArr = array("None", "Mild", "Moderate", "Severe");

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("HA ST Report");
            $colarr = Helpers_GetExcelColumn::get();

            $rowi=1;
            $sheet->setCellValue($colarr[0].$rowi++, "Pt Ax Simple Report");
            $sheet->setCellValue($colarr[0].$rowi, "病人");
            $sheet->setCellValue($colarr[1].$rowi++, $name);
            $sheet->setCellValue($colarr[0].$rowi, "負責言語治療師");
            $sheet->setCellValue($colarr[1].$rowi++, $stName);
            $sheet->setCellValue($colarr[0].$rowi++, "最近記錄");
            $sheet->setCellValue($colarr[0].$rowi, "評估日期");
            $sheet->setCellValue($colarr[1].$rowi, "結果");
            $sheet->setCellValue($colarr[2].$rowi++, "from which test");

            foreach ($data as $value) {
                $recordFirstRow = $rowi;
                $sheet->setCellValue($colarr[0].$recordFirstRow, $value["confirm_date"]);
                $sheet->setCellValue($colarr[2].$recordFirstRow, $value["type"]);

                // result
                foreach ($value["result"] as $key => $resultItem) {
                    $resultString = "";
                    for ($i=0; $i < count($resultItem["options"]); $i++) {
                        $box = "";
                        if (strlen($resultItem["selected"]) > 0 && $i == $resultItem["selected"]) {
                            $box = $checkedBox;
                        }
                        else {
                            $box = $uncheckedBox;
                        }
                        $resultString .= $box.$resultItem["options"][$i];
                    }

                    $sheet->setCellValue($colarr[1].$recordFirstRow++, $key." ".$resultString);
                }

                $rowi = $recordFirstRow;
            }

            if (empty($startdate) && empty($enddate)) {
                $trainingPeriod = "All";
            }
            else {
                if (empty($startdate)) {
                    $startdate = "Past";
                }
                if (empty($enddate)) {
                    $enddate = "Current";
                }
                $trainingPeriod = $startdate." to ".$enddate;
            }

            $rowi += 3;
            // ex simple
            $exData = $this->getExerciseData($userid, $startdate, $enddate);
            $sheet->setCellValue($colarr[0].$rowi++, "Pt Ex Simple Report");
            $sheet->setCellValue($colarr[0].$rowi, "參加者");
            $sheet->setCellValue($colarr[1].$rowi++, $name);
            $sheet->setCellValue($colarr[0].$rowi, "負責言語治療師");
            $sheet->setCellValue($colarr[1].$rowi++, $stName);
            $sheet->setCellValue($colarr[0].$rowi, "訓練時段");
            $sheet->setCellValue($colarr[1].$rowi++, $trainingPeriod);
            $sheet->setCellValue($colarr[0].$rowi, "報告日期");
            $sheet->setCellValue($colarr[1].$rowi++, date("Y-m-d"));

            $rowi++;
            $sheet->setCellValue($colarr[0].$rowi, "訓練內容");	
			$sheet->setCellValue($colarr[1].$rowi, "練習");
            $sheet->setCellValue($colarr[2].$rowi, "難度");
            $sheet->setCellValue($colarr[3].$rowi, "總共練習時數");
            $sheet->setCellValue($colarr[4].$rowi, "平均分數");
            $sheet->setCellValue($colarr[5].$rowi, "最高得分");
            $sheet->setCellValue($colarr[6].$rowi, "個別練習");
            $sheet->setCellValue($colarr[7].$rowi, "小組");
            $sheet->setCellValue($colarr[8].$rowi, "總共練習次數");
			

            foreach ($exData as $item) {
                $rowi++;				
				$sheet->setCellValue($colarr[0].$rowi, $item["exeName"]);
                $sheet->setCellValue($colarr[1].$rowi, $item["exeNum"]);
                $sheet->setCellValue($colarr[2].$rowi, $item["exeLevel"]);
                $sheet->setCellValue($colarr[3].$rowi, $item["totalHour"]);
                $sheet->setCellValue($colarr[4].$rowi, $item["avgScore"]);
                $sheet->setCellValue($colarr[5].$rowi, $item["maxScore"]);
                $sheet->setCellValue($colarr[6].$rowi, $item["numIndExe"]);
                $sheet->setCellValue($colarr[7].$rowi, $item["numGrpExe"]);
                $sheet->setCellValue($colarr[8].$rowi, $item["numExe"]);
            }


            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }
            return $this->saveExcel($objPHPExcel, "ha_st_".$serviceuserid);
        }


        function getGroupReport($startdate, $enddate) {
            //$query = $this->pdo->prepare("SELECT * FROM (SELECT att.puserid, setting.exe_code, setting.exe_name, setting.exe_id, att.attempt_score, att.attempt_percentage, att.attempt_start_datetime FROM ams.attempt_set att, ams.exe_setting setting WHERE att.exe_name = setting.exe_id AND att.attempt_start_datetime >=? AND att.attempt_start_datetime <=DATE_ADD(?, INTERVAL 1 DAY)) t1 LEFT JOIN (SELECT serviceuserid, speech_therapy_timeslot_opt1, speech_therapy_timeslot_opt2, speech_therapy_timeslot_opt3, speech_therapy_timeslot_opt4, speech_therapy_timeslot_opt5, speech_therapy_timeslot_opt6, speech_therapy_timeslot_opt7, speech_therapy_timeslot_opt8, speech_therapy_timeslot_opt9, speech_therapy_timeslot_opt10, speech_therapy_timeslot_opt11, speech_therapy_timeslot_opt12, speech_therapy_timeslot_opt13, speech_therapy_timeslot_opt14, speech_therapy_timeslot_opt15, speech_therapy_timeslot_opt16, speech_therapy_timeslot_opt17, speech_therapy_timeslot_opt18, speech_therapy_timeslot_opt19, speech_therapy_timeslot_opt20, speech_therapy_timeslot_opt21 FROM e2care.casehistory WHERE confirm_date = (SELECT MAX(confirm_date) confirm_date FROM e2care.casehistory WHERE form_state = 4)) t2 ON t2.serviceuserid = (SELECT serviceuserid FROM e2care.serviceuser WHERE puserid = t1.puserid)");
            $query = $this->pdo->prepare("select * from (SELECT su.serviceuserid, att.puserid, setting.exe_code, setting.exe_name, setting.exe_id, att.attempt_score, att.attempt_percentage, att.attempt_start_datetime FROM ams.attempt_set att, ams.exe_setting setting , e2care.serviceuser su WHERE att.exe_name = setting.exe_id AND att.puserid = su.puserid AND att.attempt_start_datetime >=? AND att.attempt_start_datetime <=DATE_ADD(?, INTERVAL 1 DAY)) t1 left join (SELECT serviceuserid, speech_therapy_timeslot_opt1, speech_therapy_timeslot_opt2, speech_therapy_timeslot_opt3, speech_therapy_timeslot_opt4, speech_therapy_timeslot_opt5, speech_therapy_timeslot_opt6, speech_therapy_timeslot_opt7, speech_therapy_timeslot_opt8, speech_therapy_timeslot_opt9, speech_therapy_timeslot_opt10, speech_therapy_timeslot_opt11, speech_therapy_timeslot_opt12, speech_therapy_timeslot_opt13, speech_therapy_timeslot_opt14, speech_therapy_timeslot_opt15, speech_therapy_timeslot_opt16, speech_therapy_timeslot_opt17, speech_therapy_timeslot_opt18, speech_therapy_timeslot_opt19, speech_therapy_timeslot_opt20, speech_therapy_timeslot_opt21 FROM e2care.casehistory WHERE confirm_date in (SELECT MAX(confirm_date) confirm_date FROM e2care.casehistory WHERE form_state = 4 group by serviceuserid)) t2 on t1.serviceuserid = t2.serviceuserid");

            if (empty($startdate)) {
                $startdate = "0000-01-01";
            }
            if (empty($enddate)) {
                $enddate = "9999-12-30";
            }
			//print_r($query);
			//exit;
            $query->execute(array($startdate, $enddate));
            $attempts = $query->fetchAll();

            $query = $this->pdo->prepare("SELECT exe_code, exe_name, exe_id, exe_type, exe_sub_type FROM (SELECT @rownum := @rownum+1 rank, exe_id, exe_type, exe_sub_type, exe_code, exe_name, SUBSTR(exe_id, 1, 1) cat, SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTR(exe_id, 2), '_', 1), '_', -1) first, SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTR(exe_id, 2), '_', 2), '_', -1) second, SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTR(exe_id, 2), '_', 3), '_', -1) third, SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTR(exe_id, 2), '_', 4), '_', -1) forth FROM ams.exe_setting, (SELECT @rownum := 0) r ORDER BY cat ASC, CAST(first as SIGNED INTEGER) ASC, CAST(second as SIGNED INTEGER) ASC, CAST(third as SIGNED INTEGER) ASC, CAST(forth as SIGNED INTEGER) ASC) t1 ORDER BY rank ASC");
			
			//print_r($query);
			
			
			
            // get max and min in each group by exe_code
            $query->execute();
            $exeCode = $query->fetchAll();
			
			//print_r($exeCode);
			
			//exit;
			
            $exeCodeData = array();
            foreach ($exeCode as $codeItem) {
                $exe_code = $codeItem["exe_code"];
				//print_r($exe_code . "<br>");
                $exe_id = $codeItem["exe_id"];
				//print_r($exe_id . "<br>");
                if (empty($exeCodeData[$exe_code])) {
                    $exeCodeData[$exe_code] = array("from" => $exe_id, "to" => $exe_id);
					//print_r($exeCodeData[$exe_code]["from"] . " from <br>");
					//print_r($exeCodeData[$exe_code]["to"] . " to <br>");
                }
                $exeCodeData[$exe_code]["to"] = $exe_id;
            }
			//exit;
            $exeTypeData = array();
            $exeCodeTypeTranslate = array();
            foreach ($exeCode as $codeItem) {
                $exe_code = $codeItem["exe_code"];
                // field that uses for grouping
                $exe_type = $codeItem["exe_name"];
                $exe_id = $codeItem["exe_id"];
                if (empty($exeTypeData[$exe_code])) {
                    $exeCodeTypeTranslate[$exe_code] = $exe_type;
                }
                if (empty($exeTypeData[$exe_type])) {
                    $exeTypeData[$exe_type] = array("from" => $exe_id, "to" => $exe_id);
                }
                $exeTypeData[$exe_type]["to"] = $exe_id;
            }

            $query = $this->pdo->prepare("SELECT cname, ename, birthdate_year, birthdate_month, birthdate_day, residental_district FROM e2care.serviceuser WHERE puserid=?");

            $data = array();
            foreach ($attempts as $att) {
                if (empty($data[$att["exe_code"]])) {
                    $data[$att["exe_code"]] = array();
                }
                // parse again according to the puserid
                if (empty($data[$att["exe_code"]][$att["puserid"]])) {
                    $data[$att["exe_code"]][$att["puserid"]] = array();
                    $data[$att["exe_code"]][$att["puserid"]]["exe"] = array();

                    $query->execute(array($att["puserid"]));
                    $userdetail = ServiceUserTranslateValue2Str::translate($query->fetchAll())[0];
                    $userAttemptName = $userdetail["cname"];
                    if (empty($userAttemptName)) {
                        $userAttemptName = $userdetail["ename"];
                    }
				//	echo($att["exe_name"] . "<br>");
                    $data[$att["exe_code"]]["exe_name"] = $att["exe_name"];
                    $data[$att["exe_code"]][$att["puserid"]]["info"] = array(
                        "serviceuserid" => $att["serviceuserid"],
                        "name" => $userAttemptName,
                        "birthdate" => implode("-", array_filter(array($userdetail["birthdate_year"], $userdetail["birthdate_month"], $userdetail["birthdate_day"]))),
                        "district" => $userdetail["residental_district_str"],
                       // "morning_1" => empty($att["speech_therapy_timeslot_opt1"]) ? "0" : $att["speech_therapy_timeslot_opt1"],
                        "morning_1" => is_null($att["speech_therapy_timeslot_opt1"]) ? "0" : "1",
                        "morning_2" => empty($att["speech_therapy_timeslot_opt2"]) ? "0" : $att["speech_therapy_timeslot_opt2"],
                        "morning_3" => empty($att["speech_therapy_timeslot_opt3"]) ? "0" : $att["speech_therapy_timeslot_opt3"],
                        "morning_4" => empty($att["speech_therapy_timeslot_opt4"]) ? "0" : $att["speech_therapy_timeslot_opt4"],
                        "morning_5" => empty($att["speech_therapy_timeslot_opt5"]) ? "0" : $att["speech_therapy_timeslot_opt5"],
                        "morning_6" => empty($att["speech_therapy_timeslot_opt6"]) ? "0" : $att["speech_therapy_timeslot_opt6"],
                        "morning_7" => empty($att["speech_therapy_timeslot_opt7"]) ? "0" : $att["speech_therapy_timeslot_opt7"],
                        "noon_1" => is_null($att["speech_therapy_timeslot_opt8"]) ? "0" : "1",
                        "noon_2" => empty($att["speech_therapy_timeslot_opt9"]) ? "0" : $att["speech_therapy_timeslot_opt9"],
                        "noon_3" => empty($att["speech_therapy_timeslot_opt10"]) ? "0" : $att["speech_therapy_timeslot_opt10"],
                        "noon_4" => empty($att["speech_therapy_timeslot_opt11"]) ? "0" : $att["speech_therapy_timeslot_opt11"],
                        "noon_5" => empty($att["speech_therapy_timeslot_opt12"]) ? "0" : $att["speech_therapy_timeslot_opt12"],
                        "noon_6" => empty($att["speech_therapy_timeslot_opt13"]) ? "0" : $att["speech_therapy_timeslot_opt13"],
                        "noon_7" => empty($att["speech_therapy_timeslot_opt14"]) ? "0" : $att["speech_therapy_timeslot_opt14"],
                        "evening_1" => is_null($att["speech_therapy_timeslot_opt15"]) ? "0" : "1",
                        "evening_2" => empty($att["speech_therapy_timeslot_opt16"]) ? "0" : $att["speech_therapy_timeslot_opt16"],
                        "evening_3" => empty($att["speech_therapy_timeslot_opt17"]) ? "0" : $att["speech_therapy_timeslot_opt17"],
                        "evening_4" => empty($att["speech_therapy_timeslot_opt18"]) ? "0" : $att["speech_therapy_timeslot_opt18"],
                        "evening_5" => empty($att["speech_therapy_timeslot_opt19"]) ? "0" : $att["speech_therapy_timeslot_opt19"],
                        "evening_6" => empty($att["speech_therapy_timeslot_opt20"]) ? "0" : $att["speech_therapy_timeslot_opt20"],
                        "evening_7" => empty($att["speech_therapy_timeslot_opt21"]) ? "0" : $att["speech_therapy_timeslot_opt21"],
                    );

                }

                array_push($data[$att["exe_code"]][$att["puserid"]]["exe"], array(
                    "exe_id" => $att["exe_id"],
                    "exe_code" => $att["exe_code"],
                    "attempt_score" => $att["attempt_score"],
                    "attempt_percentage" => $att["attempt_percentage"],
                    "datetime" => $att["attempt_start_datetime"],
                ));
            }
			//exit;
           //  print_r($data);exit();

            $objPHPExcel = $this->createExcel();
            $sheet = $objPHPExcel->getActiveSheet();
            $sheet->setTitle("Draw patients for groups");
            $colarr = Helpers_GetExcelColumn::get();
            $sheet->setCellValue($colarr[0]."1", "Training category");
            $sheet->setCellValue($colarr[1]."1", "From Chaper");
            $sheet->setCellValue($colarr[2]."1", "To Chapter");
            $sheet->setCellValue($colarr[3]."1", "Trainer");
            $sheet->setCellValue($colarr[4]."1", "Names of patients practising these exercises in the past (one/three/six) month (filter)");
            $sheet->setCellValue($colarr[5]."1", "Age (filter)");
            $sheet->setCellValue($colarr[6]."1", "District (Filter)");
            $sheet->setCellValue($colarr[7]."1", "Most recent practice date and time (sorting desc/asc)");
            $sheet->setCellValue($colarr[8]."1", "Available time");
            $sheet->setCellValue($colarr[16]."1", "Average score (sorting desc/asc)");
            $sheet->setCellValue($colarr[17]."1", "Highest score (sorting desc/asc)");

            $rowi = 1;

            foreach ($data as $exe_code => $item) {
                $rowi++;
                // $sheet->setCellValue($colarr[0].$rowi, $item["exe_name"]);
                $sheet->setCellValue($colarr[0].$rowi, $exeCodeTypeTranslate[$exe_code]);
                $sheet->setCellValue($colarr[1].$rowi, $exeTypeData[$exeCodeTypeTranslate[$exe_code]]["from"]);
                $sheet->setCellValue($colarr[2].$rowi, $exeTypeData[$exeCodeTypeTranslate[$exe_code]]["to"]);
                unset($item["exe_name"]);
                $latestDate = date("0000-00-00 00:00:00");
                $highestScore = 0;
                $averageScore = 0;
                $scoreCount = 0;
                foreach ($item as $attemptPuserid => $userAtt) {
                    foreach ($userAtt["exe"] as $itemExe) {
                        if (intval($itemExe["attempt_percentage"]) > $highestScore) {
                            $highestScore = intval($itemExe["attempt_percentage"]);
                        }
                        $averageScore += intval($itemExe["attempt_percentage"]);
                        if (date($itemExe["datetime"]) > $latestDate) {
                            $latestDate = date($itemExe["datetime"]);
                        }
                        $scoreCount++;
                    }

                    $sheet->setCellValue($colarr[4].$rowi, implode(" - ", array_filter(array($userAtt["info"]["name"],$userAtt["info"]["serviceuserid"], $attemptPuserid))));
                    $sheet->setCellValue($colarr[5].$rowi, $userAtt["info"]["birthdate"]);
                    $sheet->setCellValue($colarr[6].$rowi, $userAtt["info"]["district"]);
                    $sheet->setCellValue($colarr[7].$rowi, $latestDate);
                    //$sheet->setCellValue($colarr[16].$rowi, $averageScore/$scoreCount);
                    $sheet->setCellValue($colarr[16].$rowi, number_format($averageScore/$scoreCount,2));
                    $sheet->setCellValue($colarr[17].$rowi, $highestScore);

                    $sheet->setCellValue($colarr[9].$rowi, "星期一");
                    $sheet->setCellValue($colarr[10].$rowi, "星期二");
                    $sheet->setCellValue($colarr[11].$rowi, "星期三");
                    $sheet->setCellValue($colarr[12].$rowi, "星期四");
                    $sheet->setCellValue($colarr[13].$rowi, "星期五");
                    $sheet->setCellValue($colarr[14].$rowi, "星期六");
                    $sheet->setCellValue($colarr[15].$rowi, "星期日");
                    $rowi++;
                    $sheet->setCellValue($colarr[8].$rowi, "早");
                    $sheet->setCellValue($colarr[9].$rowi, $userAtt["info"]["morning_1"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[10].$rowi, $userAtt["info"]["morning_2"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[11].$rowi, $userAtt["info"]["morning_3"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[12].$rowi, $userAtt["info"]["morning_4"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[13].$rowi, $userAtt["info"]["morning_5"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[14].$rowi, $userAtt["info"]["morning_6"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[15].$rowi, $userAtt["info"]["morning_7"]=="0" ? "" : "✓");
                    $rowi++;
                    $sheet->setCellValue($colarr[8].$rowi, "午");
                    $sheet->setCellValue($colarr[9].$rowi, $userAtt["info"]["noon_1"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[10].$rowi, $userAtt["info"]["noon_2"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[11].$rowi, $userAtt["info"]["noon_3"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[12].$rowi, $userAtt["info"]["noon_4"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[13].$rowi, $userAtt["info"]["noon_5"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[14].$rowi, $userAtt["info"]["noon_6"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[15].$rowi, $userAtt["info"]["noon_7"]=="0" ? "" : "✓");
                    $rowi++;
                    $sheet->setCellValue($colarr[8].$rowi, "晚");
                    $sheet->setCellValue($colarr[9].$rowi, $userAtt["info"]["evening_1"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[10].$rowi, $userAtt["info"]["evening_2"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[11].$rowi, $userAtt["info"]["evening_3"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[12].$rowi, $userAtt["info"]["evening_4"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[13].$rowi, $userAtt["info"]["evening_5"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[14].$rowi, $userAtt["info"]["evening_6"]=="0" ? "" : "✓");
                    $sheet->setCellValue($colarr[15].$rowi, $userAtt["info"]["evening_7"]=="0" ? "" : "✓");
                    $rowi++;
                }
            }

            $lastCol = PHPExcel_Cell::columnIndexFromString($sheet->getHighestColumn());
            for($coli=0; $coli<$lastCol; $coli++) {
                $sheet->getColumnDimension($colarr[$coli])->setAutoSize(true);
            }

            return $this->saveExcel($objPHPExcel, "patient_group_".$serviceuserid);
        }
    }
?>
